/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipApm_Public.h 60643 2016-04-13 12:53:06Z RalfH $:

Description:
  EtherNet/IP AP task
  Public definitions

Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 2006-12-15    created
**************************************************************************************/
#ifndef __EIP_EIPAPM_PUBLIC_H
#define __EIP_EIPAPM_PUBLIC_H


/***************************************************************************************/
/* Eip DpmIntf public, constants */

#define EIP_EIPAPM_PROCESS_QUEUE_NAME       "EIPAPM_QUE"

/* Warmstart System Flags */
#define WSTART_SYSFLAG_START_MSK            0x00000001
#define WSTART_SYSFLAG_START_APPLICATION    0x00000001
#define WSTART_SYSFLAG_START_AUTO           0x00000000

#define WSTART_SYSFLAG_IOSTAT_ENABLE_MSK    0x00000002
#define WSTART_SYSFLAG_IOSTAT_ENABLED_MSK   0x00000002
#define WSTART_SYSFLAG_IOSTAT_DISABLED_MSK  0x00000000

#define WSTART_SYSFLAG_IOSTAT_LEN_MSK       0x00000004
#define WSTART_SYSFLAG_IOSTAT_LEN_8BIT      0x00000004
#define WSTART_SYSFLAG_IOSTAT_LEN_32BIT     0x00000000

#define EIP_UNREGISTER_FORCE                0x00000001

/***************************************************************************************/
/* Eip DpmIntf public, types */


/***************************************************************************************/
/* Eip DpmIntf public, commands */

/*                                            0x00003600*/ /* obsolete  */
/*                                            0x00003601*/

  #define EIP_APM_CLEAR_WATCHDOG_REQ          0x00003602   /* not used yet               */
  #define EIP_APM_CLEAR_WATCHDOG_CNF          0x00003603

  #define EIP_APM_REGISTER_APP_REQ            0x00003604   /* Register application       */
  #define EIP_APM_REGISTER_APP_CNF            0x00003605
  #define EIP_APM_UNREGISTER_APP_REQ          0x00003606   /* Unregister application     */
  #define EIP_APM_UNREGISTER_APP_CNF          0x00003607

/*#define EIP_APM_SET_CONFIGURATION_REQ       0x00003608*/ /* Space holder */
/*#define EIP_APM_SET_CONFIGURATION_CNF       0x00003609*/

  #define EIP_APM_SET_PARAMETER_REQ           0x0000360A
  #define EIP_APM_SET_PARAMETER_CNF           0x0000360B

  #define EIP_APM_MS_NS_CHANGE_IND            0x0000360C
  #define EIP_APM_MS_NS_CHANGE_RES            0x0000360D

  #define EIP_APM_GET_MS_NS_REQ               0x0000360E
  #define EIP_APM_GET_MS_NS_CNF               0x0000360F

  #define EIP_APM_ACD_LIMIT_RATE_TIMER_IND    0x00003610
  #define EIP_APM_ACD_LIMIT_RATE_TIMER_RES    0x00003611


/***************************************************************************************/
/* Eip DpmIntf public, packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(EIP_EIPAPM_PUBLIC)
#endif

/*#####################################################################################*/
/*#####################################################################################*/

/* Clear Watchdog Message */
typedef struct  EIP_APM_PACKET_CLEAR_WATCHDOG_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
} EIP_APM_PACKET_CLEAR_WATCHDOG_REQ_T;

#define EIP_APM_CLEAR_WATCHDOG_REQ_SIZE 0

typedef struct  EIP_APM_PACKET_CLEAR_WATCHDOG_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
} EIP_APM_PACKET_CLEAR_WATCHDOG_CNF_T;

#define EIP_APM_CLEAR_WATCHDOG_CNF_SIZE 0

/*#####################################################################################*/
/*#####################################################################################*/

typedef struct  EIP_APM_PACKET_REGISTER_APP_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
} EIP_APM_PACKET_REGISTER_APP_REQ_T;

#define EIP_APM_REGISTER_APP_REQ_SIZE 0

typedef struct  EIP_APM_PACKET_REGISTER_APP_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
} EIP_APM_PACKET_REGISTER_APP_CNF_T;

#define EIP_APM_REGISTER_APP_CNF_SIZE 0

/*#####################################################################################*/
/*#####################################################################################*/

typedef __PACKED_PRE struct EIP_APM_UNREGISTER_APP_REQ_Ttag {
  TLR_UINT32   ulFlag;                  /*!< Unregister options */
}__PACKED_POST  EIP_APM_UNREGISTER_APP_REQ_T;

typedef struct  EIP_APM_PACKET_UNREGISTER_APP_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;
  EIP_APM_UNREGISTER_APP_REQ_T  tData;
} EIP_APM_PACKET_UNREGISTER_APP_REQ_T;

#define EIP_APM_UNREGISTER_APP_REQ_SIZE sizeof(EIP_APM_UNREGISTER_APP_REQ_T)

typedef struct  EIP_APM_PACKET_UNREGISTER_APP_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
} EIP_APM_PACKET_UNREGISTER_APP_CNF_T;

#define EIP_APM_UNREGISTER_APP_CNF_SIZE 0


/*#####################################################################################*/
/*#####################################################################################*/

#define EIP_APM_PRM_SIGNAL_MS_NS_CHANGE            0x00000001 /*!< This flag enables or disables the notification of
                                                                   the network and module status. Every time the status
                                                                   of the module or network changes packet
                                                                   EIP_APM_MS_NS_CHANGE_IND will be sent to the
                                                                   registered EtherNet/IP Application task.    */

typedef __PACKED_PRE struct EIP_APM_SET_PARAMETER_REQ_Ttag
{
  TLR_UINT32  ulParameterFlags;    /*!< Parameter flags \n

                                       \description
                                       \ref EIP_APM_PRM_SIGNAL_MS_NS_CHANGE\n
                                       If set, this flag enables the notification of
                                       the network and module status. Every time the status
                                       of the module or network changes packet
                                       EIP_APM_MS_NS_CHANGE_IND will be sent to the
                                       registered EtherNet/IP Application task. */

}__PACKED_POST  EIP_APM_SET_PARAMETER_REQ_T;

#define EIP_APM_SET_PARAMETER_REQ_SIZE (sizeof(EIP_APM_SET_PARAMETER_REQ_T))

typedef struct EIP_APM_PACKET_SET_PARAMETER_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EIP_APM_SET_PARAMETER_REQ_T     tData;
} EIP_APM_PACKET_SET_PARAMETER_REQ_T;

 #define EIP_APM_SET_PARAMETER_CNF_SIZE 0

typedef struct EIP_APM_PACKET_SET_PARAMETER_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} EIP_APM_PACKET_SET_PARAMETER_CNF_T;


/*#####################################################################################*/

typedef __PACKED_PRE struct EIP_APM_MS_NS_CHANGE_IND_Ttag
{
  TLR_UINT32  ulModuleStatus;     /*!< Module Status \n

                                       \description
                                       The module status describes the current state of the
                                       corresponding MS-LED (provided that it is connected).
                                       See \ref EIP_HW_MODUL_STATUS_E for more details. */

  TLR_UINT32  ulNetworkStatus;     /*!< Network Status \n

                                       \description
                                       The network status describes the current state of the
                                       corresponding NS-LED (provided that it is connected).
                                       See \ref EIP_HW_NET_STATUS_E for more details. */

}__PACKED_POST  EIP_APM_MS_NS_CHANGE_IND_T;

#define EIP_APM_MS_NS_CHANGE_IND_SIZE (sizeof(EIP_APM_MS_NS_CHANGE_IND_T))

typedef struct EIP_APM_PACKET_MS_NS_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EIP_APM_MS_NS_CHANGE_IND_T      tData;
} EIP_APM_PACKET_MS_NS_CHANGE_IND_T;


#define EIP_APM_MS_NS_CHANGE_RES_SIZE 0

typedef struct EIP_APM_PACKET_MS_NS_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
} EIP_APM_PACKET_MS_NS_CHANGE_RES_T;

/*#####################################################################################*/
/*#####################################################################################*/

#define EIP_APM_GET_MS_NS_REQ_SIZE       0

typedef struct EIP_APM_PACKET_GET_MS_NS_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
} EIP_APM_PACKET_GET_MS_NS_REQ_T;


typedef __PACKED_PRE struct EIP_APM_GET_MS_NS_CNF_Ttag
{
  TLR_UINT32  ulModuleStatus;     /*!< Module Status \n

                                       \description
                                       The module status describes the current state of the
                                       corresponding MS-LED (provided that it is connected).
                                       See \ref EIP_HW_MODUL_STATUS_E for more details. */

  TLR_UINT32  ulNetworkStatus;     /*!< Network Status \n

                                       \description
                                       The network status describes the current state of the
                                       corresponding NS-LED (provided that it is connected).
                                       See \ref EIP_HW_NET_STATUS_E for more details. */

}__PACKED_POST  EIP_APM_GET_MS_NS_CNF_T;

#define EIP_APM_GET_MS_NS_CNF_SIZE  sizeof(EIP_APM_GET_MS_NS_CNF_T)

typedef struct EIP_APM_PACKET_GET_MS_NS_CNF_Ttag
{
  TLR_PACKET_HEADER_T      tHead;
  EIP_APM_GET_MS_NS_CNF_T  tData;

} EIP_APM_PACKET_GET_MS_NS_CNF_T;

/*#####################################################################################*/
/*#####################################################################################*/

/*################################################################################*/
/* RCX_LINK_STATUS_CHANGE_IND/RES                                                 */
/*################################################################################*/
#ifndef RCX_LINK_STATUS_CHANGE_IND

/*! \addtogroup RCX_LINK_STATUS_CHANGE_IND_Content
 * \{ */
#define RCX_LINK_STATUS_CHANGE_IND                      0x00002F8A
#define RCX_LINK_STATUS_CHANGE_RES                      0x00002F8B
/*! \}*/


/*! \defgroup RCX_LINK_STATUS_CHANGE_IND_Content Command related contents
 *  \ingroup RCX_LINK_STATUS_CHANGE_IND
 * \{ */
/***** indication packet *****/

typedef __PACKED_PRE struct RCX_LINK_STATUS_Ttag
{

  TLR_UINT32    ulPort;           /*!< Port number\n\n

                                       \valueRange \n
                                       0: Port 1 \n
                                       1: Port 2 */

  TLR_BOOLEAN32 fIsFullDuplex;    /*!< Duplex mode\n\n

                                       \valueRange \n
                                       0: Half duplex \n
                                       1: Full Duplex */

  TLR_BOOLEAN32 fIsLinkUp;        /*!< Link status\n\n

                                       \valueRange \n
                                       0: Link is down \n
                                       1: Link is up */

  TLR_UINT32    ulSpeed;          /*!< Port speed\n\n

                                       \valueRange \n
                                       0:   (No link) \n
                                       10:  10MBit    \n
                                       100: 100MBit   \n */

} __PACKED_POST RCX_LINK_STATUS_T;


typedef __TLR_PACKED_PRE struct RCX_LINK_STATUS_CHANGE_IND_DATA_Ttag
{
  RCX_LINK_STATUS_T  atLinkData[2]; /*!< Link status data (see \ref RCX_LINK_STATUS_Ttag)*/

} __TLR_PACKED_POST RCX_LINK_STATUS_CHANGE_IND_DATA_T;

typedef __TLR_PACKED_PRE struct RCX_LINK_STATUS_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  RCX_LINK_STATUS_CHANGE_IND_DATA_T tData;
} __TLR_PACKED_POST RCX_LINK_STATUS_CHANGE_IND_T;

#define RCX_LINK_STATUS_CHANGE_IND_SIZE (sizeof(RCX_LINK_STATUS_CHANGE_IND_DATA_T))


/***** response packet *****/
typedef struct RCX_LINK_STATUS_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
} RCX_LINK_STATUS_CHANGE_RES_T;

#define RCX_LINK_STATUS_CHANGE_RES_SIZE   (0)

#endif
/*! \}*/


/*################################################################################*/
/*################################################################################*/

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(EIP_EIPAPM_PUBLIC)
#endif



/***************************************************************************************/
/* Eip DpmIntf public, prototypes */



/***************************************************************************************/
#endif /* #ifndef __EIP_EIPAPM_PUBLIC_H */
